<?php
/**
 * Global functions for Landing WordPress plugin.
 *
 * Механизмы плагина
 *
 * @package veselka_landing
 */


/**
 * Переводы.
 */
function init_landing_textdomain() {
	$path = LANDING_DIR_NAME . '/lang';
	if( is_admin() ) {
		$path .= '/admin';
	}
	load_plugin_textdomain('landing', false, $path );
}
add_action( 'init', 'init_landing_textdomain' );


/**
 * Инструменты бэкэнда.
 */
if( is_admin() ) {
	/**
	 * Подключение дополнительных типов страниц.
	 */
	require_once LANDING_PATH . '/lib/registration.class.php';
	$landing_registration = new LandingRegistration();
	/**
	 * Термин таксономии по умолчанию.
	 */
	require_once LANDING_PATH . '/lib/default.class.php';
	$landing_default = new LandingDefault();
} else {
	/**
	 * Подключение библиотек фронтэнда.
	 */
	require_once LANDING_PATH . '/lib/elements.class.php';
	$landing_elements = new LandingElements();
}


/**
 * Замена шаблонов в выпадающих списках.
 */
require_once LANDING_PATH . '/lib/templater.class.php';
add_action( 'plugins_loaded', [ 'LandingTemplater', 'get_instance' ] );

?>