/**
 * Landing events
 *
 * @author veselka.ua
 * @version 0.2
 * @modify 16-03-2018
 */

var landingEvents = (function ($)
{
	$.runLandingEvents = {

		origOffsetY: 0,

		init: function ()
		{
			//this.formActions();
			var _this = this;

			/* Scroll */
			this.scrollInit();
			this.scrollActions();
			this.scrollSpy();
			$(window).scroll(function() {
				_this.scrollActions();
			});

			// Video
			if( $('.play').length > 0 )
			{
				$(function(){
					$('.play').mb_YTPlayer();
					$('.tmp-background').css('background','none');
				});
			}
		},


		/**
		 * Scroll init function
		 */
		scrollInit: function() {
			/* Nav menu transform */
			if( $('.navbar').length > 0 )
			{
				this.origOffsetY = $('.navbar').offset().top;
			}
		},


		/**
		 * Scroll actions
		 */
		scrollActions: function() {
			if( $(window).width() >= 753 )
			{
				//var urlRelative = $('#navbar-logo').attr('src');
				//var cond = urlRelative.split('navbar_logo');
				if( $(window).scrollTop() >= this.origOffsetY )
				{
					if( !$('#navbar-landing').hasClass('navbar-fixed-top') )
					{
						$('#navbar-landing').addClass('navbar-fixed-top');
						$('#navbar-landing').removeClass('navbar-transparent');
					}
					if( $('#btn-scrolldown').hasClass('visible-landing-btn') )
					{
						$('#btn-scrolldown').addClass('hidden-landing-btn');
						$('#btn-scrolldown').removeClass('visible-landing-btn');
					}
				}
				else
				{
					if( !$('#navbar-landing').hasClass('navbar-transparent') )
					{
						$('#navbar-landing').addClass('navbar-transparent');
						$('#navbar-landing').removeClass('navbar-fixed-top');
					}
					if( $('#btn-scrolldown').hasClass('hidden-landing-btn') )
					{
						$('#btn-scrolldown').addClass('visible-landing-btn');
						$('#btn-scrolldown').removeClass('hidden-landing-btn');
					}
				}
			}
		},


		/**
		 * Scrollspy
		 */
		scrollSpy: function() {
			/* ScrollSpy animation */
			$("nav a[href^='#'], #btn-scrolldown a[href^='#']").on('click', function(event)
			{
				var _this = this;
				// prevent default anchor click behavior
				event.preventDefault();
				$('.navbar-collapse').collapse('hide');
				$('html, body').animate({ scrollTop: $(_this.hash).offset().top }, 800, function()
				{
					// when done, add hash to url (default click behaviour)
					window.location.hash = _this.hash;
				});
			});
			$(".navbar li a[href^='#']").on('click', function(event)
			{
				$('#scroll-spy-menu').collapse('hide');

			});
		},

	};

})(jQuery);

$(document).ready(function()
{
	$.runLandingEvents.init();
});


