/**
 * jQuery count down plugin
 *
 * @author veselka.ua
 * @license: http://www.opensource.org/licenses/mit-license.php
 * @version 0.2
 * @modify 17-04-2017
 */

var dateCountDown = (function ($)
{
	$.runCountDown = {


		/**
		 * Data
		 */
		data: {
		},


		/**
		 * Default data
		 */
		default_data: {

			startDate: new Date(),
			endDate: '',

			refreshed: 1000,
			thread: null,
			running: false,
			left: 0,
			decreament: 1,
			interval: 0,
			
			seconds: 0,
			minutes: 0,
			hours: 0,
			days: 0,
			
			elemDays: null,
			elemHours: null,
			elemMinutes: null,
			elemSeconds: null,

			onBevoreStart: null,		// callback before the count down starts
			onClocking: null,			// callback after the timer just clocked
			onFinish: null,				// callback if the count down is finish or 0 timer defined
		},


		/**
		 * Count down options
		 */
		options: {
			dcContainer: '.date-count-down',
			translateContainer: '.dc-translate',
			
			titleDays: '',
			titleHours: '',
			titleMinutes: '',
			titleSeconds: '',
		},


		/**
		 * Init method
		 */
		init: function ()
		{
			var _this = this;
			// Title translates
			this.getTranslate();

			// Search counters
			$.each( $(this.options.dcContainer), function(e) {
				// Index
				var i = $(this).attr('id');
				// Set Obj
				_this.data[i] = {};
				// Load defaults
				$.each( _this.default_data, function(name, data) {
					_this.data[i][name] = data;
				});	
				// Get counter data
				_this.data[i].endDate = new Date( $(this).data('timer') );
				// Identificator
				_this.data[i].id = '#' + i;

			});

			// Start counters
			$.each( this.data, function(i, data) {
				// Inject html layout
				_this.insertTags(i);
				// Inject date information
				_this.setCounterData(i);
				// Start count down
				_this.start(i);
			});
		},


		/**
		 * Get translate
		 */
		getTranslate: function()
		{
			this.options.titleDays = $(this.options.translateContainer).data('days');
			this.options.titleHours = $(this.options.translateContainer).data('hours');
			this.options.titleMinutes = $(this.options.translateContainer).data('minutes');
			this.options.titleSeconds = $(this.options.translateContainer).data('seconds');
		},


		/**
		 * Inserts start html layuot
		 * @param i
		 */
		insertTags: function(i)
		{
			// Seconds
			$(this.data[i].id).prepend(
				'<div class="dc-element dc-element-seconds">'+
				'	<div class="dc-element-value dc-seconds">00</div>'+
				'	<div class="dc-element-title">'+ this.options.titleSeconds +'</div>'+
				'</div>'
			);
			this.data[i].elemSeconds = $(this.data[i].id).find('.dc-seconds');
			// Minutes
			$(this.data[i].id).prepend(
				'<div class="dc-element dc-element-minutes">'+
				'	<div class="dc-element-value dc-minutes">00</div>'+
				'	<div class="dc-element-title">'+ this.options.titleMinutes +'</div>'+
				'</div>'
			);
			this.data[i].elemMinutes = $(this.data[i].id).find('.dc-minutes');
			// Hours
			$(this.data[i].id).prepend(
				'<div class="dc-element dc-element-hours">'+
				'	<div class="dc-element-value dc-hours">00</div>'+
				'	<div class="dc-element-title">'+ this.options.titleHours +'</div>'+
				'</div>'
			);
			this.data[i].elemHours = $(this.data[i].id).find('.dc-hours');			
			// Days
			$(this.data[i].id).prepend(
				'<div class="dc-element dc-element-days">'+
				'	<div class="dc-element-value dc-days">00</div>'+
				'	<div class="dc-element-title">'+ this.options.titleDays +'</div>'+
				'</div>'
			);
			this.data[i].elemDays = $(this.data[i].id).find('.dc-days');
		},


		/**
		 * Set counter data
		 * @param i
		 */
		setCounterData: function(i)
		{
			// Init start and end
			if( this.data[i].startDate && this.data[i].endDate )
			{
				this.data[i].interval = this.data[i].endDate.getTime() - this.data[i].startDate.getTime();
				if( this.data[i].interval > 0 )
				{
					var allSeconds = (this.data[i].interval / 1000);
					var hoursMod = (allSeconds % 86400);
					var minutesMod = (hoursMod % 3600);
					
					this.data[i].left = allSeconds;
					this.data[i].days = Math.floor(allSeconds / 86400);
					this.data[i].hours = Math.floor(hoursMod / 3600);
					this.data[i].minutes = Math.floor(minutesMod / 60);
					this.data[i].seconds = Math.floor(minutesMod % 60);
				}
			}
		},


		/**
		 * Stop counter
		 * @param callback
		 * @param i
		 */
		stop: function(callback,i)
		{
			if( this.data[i].running )
			{
				clearInterval(this.data[i].thread);
				this.data[i].running = false;
			}
			if( callback )
			{
				callback(this);
			}
		},


		/**
		 * Start counter
		 * @param i
		 */
		start: function(i)
		{
			// Already running
			if( this.data[i].running )
			{
				return true;
			}
			// Couner not finished

			if( this.data[i].left > 0 )
			{
				if( this.data[i].onBevoreStart )
				{
					this.data[i].onBevoreStart(this);
				}
				var _this = this;
				this.data[i].thread = setInterval( function(){_this.setRoundData(i)}, this.data[i].refreshed );
				this.data[i].running = true;
			}
			else
			{
				if( this.data[i].onFinish )
				{
					this.data[i].onFinish(this);
				}
			}

		},


		/**
		 * Set counter data in html layout
		 * @param i
		 */
		setRoundData: function(i)
		{
			if( this.data[i].left > 0 )
			{
				this.data[i].left -= this.data[i].decreament;
				this.data[i].seconds -= this.data[i].decreament;

				if( this.data[i].seconds <= 0 && (this.data[i].minutes > 0 || this.data[i].hours > 0 || this.data[i].days > 0) )
				{	
					this.data[i].minutes --;
					this.data[i].seconds = 60;
				}

				if( this.data[i].minutes <= 0 && (this.data[i].hours > 0 || this.data[i].days > 0) )
				{
					this.data[i].hours --;
					this.data[i].minutes = 60;
				}

				if( this.data[i].hours <= 0 && this.data[i].days > 0 )
				{
					this.data[i].days --;
					this.data[i].hours = 24;
				}

				if( this.data[i].elemDays )
				{
					this.data[i].elemDays.html((this.data[i].days < 10 ? '0' + this.data[i].days : this.data[i].days));
				}
				if( this.data[i].elemHours )
				{
					this.data[i].elemHours.html((this.data[i].hours < 10 ? '0' + this.data[i].hours : this.data[i].hours));
				}
				if( this.data[i].elemMinutes )
				{
					this.data[i].elemMinutes.html((this.data[i].minutes < 10 ? '0' + this.data[i].minutes : this.data[i].minutes));
				}
				if( this.data[i].elemSeconds )
				{
					this.data[i].elemSeconds.html((this.data[i].seconds < 10 ? '0' + this.data[i].seconds : this.data[i].seconds));
				}
				if( this.data[i].onClocking )
				{
					this.data[i].onClocking(this);
				}
			}
			else
			{
				this.stop(this.data[i].onFinish,i);
			}
		},

	};

})(jQuery);

$(document).ready(function()
{
	$.runCountDown.init();
});